#ifndef JEU_H_INCLUDED
#define JEU_H_INCLUDED

#include <SDL/SDL.h>
#include <SDL/SDL_image.h>
#include <SDL/SDL_ttf.h>
#include <SDL/SDL_mixer.h>
#include <time.h>
#include "typedef.h"
#include "map.h"
#include "reseau.h"

#define DISTANCE_VISIBLE 2
#define DISTANCE_INCONNU 1
#define MOONWALK 0

long initialiser_jeu(t_interface *interface,t_partie *jeu, t_serveur *serv); //Initialise les variables de la structure partie
long charger_tileset(t_tileset *tileset, long alpha);
long ajouter_pion(t_partie *jeu, long joueur, type_pion type, long pts, long x, long y);
void liberer_jeu(t_partie *jeu);
long ajouter_anim(t_pion *pion, enum anim_type type, long x, long y, long valeur);
void afficher_pions(t_interface *interface,t_partie *jeu);
enum pion_angle obtenir_angle(long x, long y);
void actualiser_brouillard(t_interface * interface,t_partie *jeu);
void bouger_pion(t_interface *interface, t_serveur *serv, t_partie *jeu, long pion);

void traiter_paquets(t_interface *inter, t_serveur *serv, t_partie *jeu);
#endif // JEU_H_INCLUDED
